import java.rmi.registry.Registry;
import java.rmi.registry.LocateRegistry;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
public class CalcServer implements Operasi
{
	public CalcServer() throws RemoteException {}
	public Double tambah(Double x, Double y) {
		return x + y;
	}
	
	public Double kurang(Double x, Double y){
		return x - y;
	}
	
	public Double kali(Double x, Double y){
		return x * y;
	}
	
	public Double bagi(Double x, Double y){
		return x / y;
	}
	
	public Double modulo(Double x, Double y){
		return x % y;
	}
	
	public Double pangkat(Double x, Double y){
		return Math.pow(x,y);
	}
	public static void main (String args[]){
		String host = (args.length < 1) ? "localhost" : args[0];
		String port = (args.length < 2) ? "1099" : args[1];
		try{
			CalcServer remoteObject = new CalcServer();
			Operasi skeleton = (Operasi)UnicastRemoteObject.exportObject(remoteObject, 0);

			Registry registry = LocateRegistry.getRegistry(host,Integer.parseInt(port));
		
			registry.rebind("operasi", skeleton);
 
			System.out.println("Server Ready !!");
		}catch (Exception e) {
			System.out.println("HelloServer Err: " + e.getMessage());
			e.printStackTrace();
		}
	}
}